<?php
// Check if installation is already complete
if (file_exists('config.php')) {
    require_once 'config.php';
    try {
        $db = getDB();
        // If we can connect and tables exist, redirect to login
        header("Location: index.php");
        exit();
    } catch (Exception $e) {
        // Continue with installation
    }
}

// Handle installation form submission
if ($_POST['action'] === 'install') {
    $db_host = $_POST['db_host'];
    $db_name = $_POST['db_name'];
    $db_user = $_POST['db_user'];
    $db_pass = $_POST['db_pass'];
    $admin_email = $_POST['admin_email'];
    $admin_password = $_POST['admin_password'];
    
    try {
        // Create database connection with provided credentials
        $db = new PDO("mysql:host=$db_host", $db_user, $db_pass);
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        // Create database
        $db->exec("CREATE DATABASE IF NOT EXISTS `$db_name`");
        $db->exec("USE `$db_name`");
        
        // Create users table
        $db->exec("CREATE TABLE IF NOT EXISTS users (
            id INT AUTO_INCREMENT PRIMARY KEY,
            username VARCHAR(100),
            email VARCHAR(255) UNIQUE NOT NULL,
            password VARCHAR(255) NOT NULL,
            is_admin BOOLEAN DEFAULT FALSE,
            is_active BOOLEAN DEFAULT TRUE,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )");
        
        // Create content table
        $db->exec("CREATE TABLE IF NOT EXISTS generated_content (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT,
            topic VARCHAR(500) NOT NULL,
            content LONGTEXT,
            word_count INT,
            content_type VARCHAR(100),
            tone VARCHAR(100),
            ai_persona VARCHAR(100),
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
        )");
        
        // Create settings table
        $db->exec("CREATE TABLE IF NOT EXISTS user_settings (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT UNIQUE,
            ai_api_key VARCHAR(255),
            default_prompt TEXT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
        )");
        
        // Create AI personas table
        $db->exec("CREATE TABLE IF NOT EXISTS ai_personas (
            id INT AUTO_INCREMENT PRIMARY KEY,
            persona_key VARCHAR(100) UNIQUE NOT NULL,
            name VARCHAR(255) NOT NULL,
            description TEXT,
            prompt_template TEXT,
            traits JSON,
            is_active BOOLEAN DEFAULT TRUE,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )");
        
        // Create content types table
        $db->exec("CREATE TABLE IF NOT EXISTS content_types (
            id INT AUTO_INCREMENT PRIMARY KEY,
            type_key VARCHAR(100) UNIQUE NOT NULL,
            name VARCHAR(255) NOT NULL,
            description TEXT,
            default_settings JSON,
            is_active BOOLEAN DEFAULT TRUE,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )");
        
        // Create app settings table
        $db->exec("CREATE TABLE IF NOT EXISTS app_settings (
            id INT AUTO_INCREMENT PRIMARY KEY,
            setting_key VARCHAR(100) UNIQUE NOT NULL,
            setting_value TEXT,
            setting_type VARCHAR(50) DEFAULT 'string',
            description TEXT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )");
        
        // Create notifications table
        $db->exec("CREATE TABLE IF NOT EXISTS notifications (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NULL,
            title VARCHAR(255) NOT NULL,
            message TEXT NOT NULL,
            type ENUM('info', 'success', 'warning', 'error') DEFAULT 'info',
            is_read BOOLEAN DEFAULT FALSE,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
        )");
        
        // Create password reset table
        $db->exec("CREATE TABLE IF NOT EXISTS password_resets (
            id INT AUTO_INCREMENT PRIMARY KEY,
            email VARCHAR(255) NOT NULL,
            token VARCHAR(100) NOT NULL,
            expires_at TIMESTAMP NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )");
        
        // Insert default AI personas
        $personas = [
            [
                'lily-seo', 
                'Lily SEO', 
                'Content strategist and SEO expert with 10+ years experience',
                'You are Lily SEO, a content strategist and SEO expert with over 10 years of hands-on experience. Your voice is direct, conversational, and mentor-like. You are known for your no-BS approach and data-driven insights.',
                '["direct", "conversational", "data-driven", "no-BS approach"]'
            ],
            [
                'technical',
                'Technical Expert',
                'Deep domain knowledge with ability to simplify complex concepts',
                'You are a technical expert with deep domain knowledge. You explain complex concepts in simple terms while maintaining technical accuracy. Your writing is precise, detailed, and backed by real-world implementation experience.',
                '["precise", "detailed", "evidence-based", "practical"]'
            ],
            [
                'creative',
                'Creative Writer', 
                'Storyteller who engages readers emotionally',
                'You are a creative writer with a flair for storytelling. You weave narratives that engage readers emotionally while delivering valuable information. Your tone is imaginative yet practical.',
                '["imaginative", "engaging", "narrative-driven", "emotional"]'
            ],
            [
                'academic',
                'Academic Researcher',
                'Rigorous analyst with evidence-based approach',
                'You are an academic researcher with rigorous analytical skills. Your writing is well-structured, evidence-based, and cites relevant studies while remaining accessible to educated laypeople.',
                '["structured", "analytical", "evidence-based", "authoritative"]'
            ],
            [
                'marketing',
                'Marketing Expert',
                'Conversion-focused writer with psychological insight',
                'You are a marketing expert who understands psychology and conversion optimization. Your writing is persuasive, benefit-focused, and always tied to measurable business outcomes.',
                '["persuasive", "benefit-focused", "results-oriented", "strategic"]'
            ]
        ];
        
        $stmt = $db->prepare("INSERT INTO ai_personas (persona_key, name, description, prompt_template, traits) VALUES (?, ?, ?, ?, ?)");
        foreach ($personas as $persona) {
            $stmt->execute($persona);
        }
        
        // Insert content types
        $contentTypes = [
            ['article', 'Article/Blog Post', 'Comprehensive articles and blog posts'],
            ['listicle', 'Listicle', 'Numbered list content'],
            ['news', 'News Post', 'News articles and updates'],
            ['product', 'Product Description', 'Product descriptions and reviews'],
            ['social', 'Social Media Post', 'Social media content'],
            ['email', 'Email Newsletter', 'Email newsletters and campaigns'],
            ['press', 'Press Release', 'Press releases'],
            ['case', 'Case Study', 'Case studies'],
            ['whitepaper', 'White Paper', 'White papers and research reports'],
            ['guide', 'How-To Guide', 'How-to guides and tutorials'],
            ['tutorial', 'Tutorial', 'Step-by-step tutorials'],
            ['faq', 'FAQ', 'Frequently asked questions'],
            ['landing', 'Landing Page', 'Landing page copy'],
            ['about', 'About Us Page', 'About us pages'],
            ['script', 'Video Script', 'Video scripts'],
            ['podcast', 'Podcast Outline', 'Podcast outlines']
        ];
        
        $stmt = $db->prepare("INSERT INTO content_types (type_key, name, description) VALUES (?, ?, ?)");
        foreach ($contentTypes as $type) {
            $stmt->execute($type);
        }
        
        // Insert app settings
        $appSettings = [
            ['default_ai_api_key', 'AIzaSyDbjf0QmBkJ1Mc0gMt0Wwp2B68nygD6zKs', 'string', 'Default AI API Key for Gemini Flash'],
            ['max_topics', '50', 'number', 'Maximum number of topics per generation'],
            ['default_word_count', '1000', 'number', 'Default word count for content generation'],
            ['max_word_count', '5000', 'number', 'Maximum word count allowed'],
            ['streaming_delay', '50', 'number', 'Delay between streaming chunks in ms'],
            ['retry_attempts', '3', 'number', 'Number of retry attempts for API calls'],
            ['admin_email', 'prudence@quillfy.com', 'string', 'Admin contact email']
        ];
        
        $stmt = $db->prepare("INSERT INTO app_settings (setting_key, setting_value, setting_type, description) VALUES (?, ?, ?, ?)");
        foreach ($appSettings as $setting) {
            $stmt->execute($setting);
        }
        
        // Create admin user
        $hashedPassword = password_hash($admin_password, PASSWORD_DEFAULT);
        $stmt = $db->prepare("INSERT INTO users (username, email, password, is_admin) VALUES (?, ?, ?, TRUE)");
        $stmt->execute(['prudence', 'prudence@quillfy.com', '!!!###1985ENi!!!']);
        
        // Create config file
        $configContent = "<?php
// Database configuration
define('DB_HOST', '$db_host');
define('DB_NAME', '$db_name');
define('DB_USER', '$db_user');
define('DB_PASS', '$db_pass');

// App configuration
define('APP_NAME', 'Bulk AI Writer');
define('APP_VERSION', '1.0');

// Session configuration
session_start();

// Database connection
function getDB() {
    static \$db = null;
    if (\$db === null) {
        try {
            \$db = new PDO(\"mysql:host=\" . DB_HOST . \";dbname=\" . DB_NAME, DB_USER, DB_PASS);
            \$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch(PDOException \$e) {
            die(\"Database connection failed: \" . \$e->getMessage());
        }
    }
    return \$db;
}

// Check if user is logged in
function isLoggedIn() {
    return isset(\$_SESSION['user_id']);
}

// Check if user is admin
function isAdmin() {
    return isset(\$_SESSION['user_id']) && isset(\$_SESSION['is_admin']) && \$_SESSION['is_admin'] === true;
}

// Redirect if not logged in
function requireLogin() {
    if (!isLoggedIn()) {
        header(\"Location: index.php\");
        exit();
    }
}

// Redirect if not admin
function requireAdmin() {
    if (!isAdmin()) {
        header(\"Location: bulkwriter.php\");
        exit();
    }
}

// Get app setting
function getAppSetting(\$key, \$default = null) {
    try {
        \$db = getDB();
        \$stmt = \$db->prepare(\"SELECT setting_value FROM app_settings WHERE setting_key = ?\");
        \$stmt->execute([\$key]);
        \$result = \$stmt->fetch(PDO::FETCH_ASSOC);
        return \$result ? \$result['setting_value'] : \$default;
    } catch (Exception \$e) {
        return \$default;
    }
}

// Get AI personas
function getAIPersonas() {
    try {
        \$db = getDB();
        \$stmt = \$db->query(\"SELECT * FROM ai_personas WHERE is_active = TRUE ORDER BY name\");
        return \$stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (Exception \$e) {
        return [];
    }
}

// Get content types
function getContentTypes() {
    try {
        \$db = getDB();
        \$stmt = \$db->query(\"SELECT * FROM content_types WHERE is_active = TRUE ORDER BY name\");
        return \$stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (Exception \$e) {
        return [];
    }
}

// Get user settings
function getUserSettings(\$user_id) {
    try {
        \$db = getDB();
        \$stmt = \$db->prepare(\"SELECT * FROM user_settings WHERE user_id = ?\");
        \$stmt->execute([\$user_id]);
        return \$stmt->fetch(PDO::FETCH_ASSOC);
    } catch (Exception \$e) {
        return null;
    }
}

// Save user settings
function saveUserSettings(\$user_id, \$settings) {
    try {
        \$db = getDB();
        \$existing = getUserSettings(\$user_id);
        
        if (\$existing) {
            \$stmt = \$db->prepare(\"UPDATE user_settings SET ai_api_key = ?, default_prompt = ?, updated_at = NOW() WHERE user_id = ?\");
            \$stmt->execute([
                \$settings['ai_api_key'] ?? null,
                \$settings['default_prompt'] ?? null,
                \$user_id
            ]);
        } else {
            \$stmt = \$db->prepare(\"INSERT INTO user_settings (user_id, ai_api_key, default_prompt) VALUES (?, ?, ?)\");
            \$stmt->execute([
                \$user_id,
                \$settings['ai_api_key'] ?? null,
                \$settings['default_prompt'] ?? null
            ]);
        }
        return true;
    } catch (Exception \$e) {
        error_log(\"Error saving user settings: \" . \$e->getMessage());
        return false;
    }
}

// Get user notifications
function getUserNotifications(\$user_id, \$unread_only = false) {
    try {
        \$db = getDB();
        if (\$unread_only) {
            \$stmt = \$db->prepare(\"SELECT * FROM notifications WHERE (user_id = ? OR user_id IS NULL) AND is_read = FALSE ORDER BY created_at DESC\");
            \$stmt->execute([\$user_id]);
        } else {
            \$stmt = \$db->prepare(\"SELECT * FROM notifications WHERE user_id = ? OR user_id IS NULL ORDER BY created_at DESC LIMIT 10\");
            \$stmt->execute([\$user_id]);
        }
        return \$stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (Exception \$e) {
        return [];
    }
}

// Mark notification as read
function markNotificationAsRead(\$notification_id, \$user_id) {
    try {
        \$db = getDB();
        \$stmt = \$db->prepare(\"UPDATE notifications SET is_read = TRUE WHERE id = ? AND (user_id = ? OR user_id IS NULL)\");
        return \$stmt->execute([\$notification_id, \$user_id]);
    } catch (Exception \$e) {
        return false;
    }
}
?>");
        
        file_put_contents('config.php', $configContent);
        
        echo '<div class="success">Installation completed successfully! <a href="index.php">Click here to login</a></div>';
        
    } catch (PDOException $e) {
        echo '<div class="error">Installation failed: ' . $e->getMessage() . '</div>';
    }
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Install Bulk AI Writer</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body class="install-page">
    <div class="install-container">
        <div class="install-header">
            <h1>🚀 Bulk AI Writer</h1>
            <p>Installation Wizard</p>
        </div>
        
        <div class="install-form">
            <form id="installForm" method="POST">
                <div class="form-group">
                    <label for="db_host">Database Host</label>
                    <input type="text" id="db_host" name="db_host" value="localhost" required>
                </div>
                
                <div class="form-group">
                    <label for="db_name">Database Name</label>
                    <input type="text" id="db_name" name="db_name" value="fuzesale_nexus" required>
                </div>
                
                <div class="form-group">
                    <label for="db_user">Database Username</label>
                    <input type="text" id="db_user" name="db_user" value="fuzesale_nexus" required>
                </div>
                
                <div class="form-group">
                    <label for="db_pass">Database Password</label>
                    <input type="password" id="db_pass" name="db_pass" required>
                </div>
                
                <div class="form-group">
                    <label for="admin_email">Admin Email</label>
                    <input type="email" id="admin_email" name="admin_email" value="prudence@quillfy.com" required>
                </div>
                
                <div class="form-group">
                    <label for="admin_password">Admin Password</label>
                    <input type="password" id="admin_password" name="admin_password" value="!!!###1985ENi!!!" required>
                </div>
                
                <button type="submit" class="btn-primary">Install Now</button>
            </form>
        </div>
        
        <div id="installResult" class="install-result"></div>
    </div>

    <script>
        document.getElementById('installForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            formData.append('action', 'install');
            
            fetch('install.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(data => {
                document.getElementById('installResult').innerHTML = data;
            })
            .catch(error => {
                document.getElementById('installResult').innerHTML = '<div class="error">Installation failed: ' + error + '</div>';
            });
        });
    </script>
</body>
</html>